<?php declare(strict_types = 1);

namespace EshopSales\ApiModule\Api\V1\Controllers;

use Apitte\Core\Annotation\Controller\Method;
use Apitte\Core\Annotation\Controller\Path;
use Apitte\Core\Http\ApiRequest;
use Apitte\Core\Http\ApiResponse;
use Apitte\Negotiation\Http\ArrayEntity;
use EshopSales\FrontModule\Model\OrderSales;

/**
 * Class CategoriesController
 * @Path("/sales")
 */
class OrderSalesController extends BaseController
{
	protected OrderSales $orderSales;

	public function __construct(OrderSales $orderSales)
	{
		$this->orderSales = $orderSales;
	}

	/**
	 * @param ApiRequest $request
	 * @param ApiResponse $response
	 * @return ApiResponse
	 * @Path("/check-discount-code-validity")
	 * @Method("POST")
	 */
	public function checkDiscountCodeValidity(ApiRequest $request, ApiResponse $response): ApiResponse
	{
		$data = $request->getJsonBody();

		try {
			$code = $data['code'];
			$cartItemsPrice = (float) $data['totalPrice'];

			$validDiscountCode = $this->orderSales->isValidDiscountCode($code, $cartItemsPrice, true);

			return $response->withStatus(ApiResponse::S200_OK)->withEntity(ArrayEntity::from([
				'status' => $validDiscountCode ? 'success' : 'error',
				'data'  => $validDiscountCode
			]));

		} catch (\Exception $e) {

			return $response->withStatus(ApiResponse::S200_OK)->withEntity(ArrayEntity::from([
				'error' => $e->getMessage(),
				'data'  => $data
			]));
		}
	}
}
