<?php declare(strict_types = 1);

namespace EshopSales\Console;

use Doctrine;
use Doctrine\ORM\Tools\Console\Command\SchemaTool\AbstractCommand;
use EshopSales\AdminModule\Model\HolidaysExport;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Style\SymfonyStyle;

class EcomailExport extends AbstractCommand
{
	/** @var null|HolidaysExport @inject */
	public ?HolidaysExport $holidaysExport = null;

	protected function configure(): void
	{
		$this->setName('eshopsales:holidayExport:ecomail')
			->addOption('site', null, InputOption::VALUE_REQUIRED)
			->addOption('lang', null, InputOption::VALUE_REQUIRED);
	}

	protected function executeSchemaCommand(InputInterface $input, OutputInterface $output, Doctrine\ORM\Tools\SchemaTool $schemaTool, array $metadatas, SymfonyStyle $ui): int
	{
		$output->writeln('EshopSales - holidays export to ecomail');

		try {
			$this->holidaysExport->exportToEcoMail(
				(string) $input->getOption('site'),
				(string) $input->getOption('lang')
			);

			$output->writeLn('<info>[OK]</info>');

			return 0;
		} catch (\Exception $e) {
			$output->writeln('<error>[ERROR] - ' . $e->getMessage() . '</error>');
		}

		return 1;
	}
}
