<?php declare(strict_types = 1);

namespace EshopSales\CronModule\Presenters;

use Core\Model\Sites;
use Currency\Model\Currencies;
use EshopProductsComparison\FrontModule\Model\ExportFacade;
use EshopSales\AdminModule\Model\OrderSales;
use Nette\Application\Responses\TextResponse;
use Nette\Utils\FileSystem;
use Nette\Utils\Strings;
use Tracy\Debugger;

class ImportPresenter extends BasePresenter
{
	protected OrderSales $orderSales;

	public function __construct(OrderSales $orderSales)
	{
		$this->orderSales = $orderSales;
	}

	/*******************************************************************************************************************
	 * ============================== Actions
	 */
	public function actionBulkImportHolidays(): void
	{
		set_time_limit(1000);
		ini_set('memory_limit', '2048M');
		Debugger::$showBar = false;

		$this->orderSales->bulkImportHolidays();
		
		$this->terminate();
	}
}
