<?php declare(strict_types = 1);

namespace EshopSales\FrontModule\Model\Event;

use EshopSales\FrontModule\Model\Dao;
use Symfony\Contracts\EventDispatcher\Event;

class OrderSalesPriceEvent extends Event
{
	/** @var Dao\OrderSale[] */
	public $orderSales;

	/** @var float */
	public $cartPrice;

	public function __construct(array &$orderSales, float $cartPrice)
	{
		$this->orderSales = &$orderSales;
		$this->cartPrice  = $cartPrice;
	}
}
