<?php declare(strict_types=1);

namespace EshopSales\Model\Entities;

use Core\Model\Entities\Site;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table("eshop_sales__order_sale_in_site")
 * @ORM\Entity
 */
class OrderSaleInSite
{
	/**
	 * @ORM\Id
	 * @ORM\ManyToOne(targetEntity="OrderSale")
	 * @ORM\JoinColumn(name="order_sale_id", referencedColumnName="id", nullable=false, onDelete="CASCADE")
	 */
	public OrderSale $orderSale;

	/**
	 * @ORM\Id
	 * @ORM\ManyToOne(targetEntity="Core\Model\Entities\Site")
	 * @ORM\JoinColumn(name="site_id", referencedColumnName="ident", nullable=false, onDelete="CASCADE")
	 */
	public Site $site;

	public function __construct(OrderSale $orderSale, Site $site)
	{
		$this->orderSale = $orderSale;
		$this->site = $site;
	}

}