<?php declare(strict_types = 1);

namespace EshopSales\Model\Subscribers;

use EshopOrders\AdminModule\Model\Event\OrderNavigationCallbackEvent;
use EshopOrders\AdminModule\Model\Event\OrdersNavigationEvent;
use EshopSales\AdminModule\Model\OrderSales;
use EshopSales\Model\EshopSalesConfig;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class OrderFormSubscriber implements EventSubscriberInterface
{
	protected const SIGNAL_KEY = 'resendDiscountCoupons';
	protected OrderSales $orderSales;

	public function __construct(
		OrderSales $orderSales
	)
	{
		$this->orderSales = $orderSales;
	}

	public static function getSubscribedEvents(): array
	{
		return [
			'eshopOrders.admin.onBeforeRenderEditOrderNavigation' => 'onRenderNavigation',
			'eshopOrders.admin.ordersDefaultNavigationCallback'   => 'onRenderNavigationCallback',
		];
	}

	public function onRenderNavigation(OrdersNavigationEvent $event): void
	{
		if (EshopSalesConfig::load('enableResendDiscountCoupons') && $event->order && $this->orderSales->getDiscountsPurchasedInOrder((int) $event->order->getId())) {
			$event->addNavigation(
				'eshopSales.orderForm.resendDiscountCoupons',
				['navigationCallback!', ['key' => self::SIGNAL_KEY]],
				'fas fa-mail-bulk',
				'ajax bg-success',
				['EshopSales:Admin' => 'access']
			);
		}
	}

	public function onRenderNavigationCallback(OrderNavigationCallbackEvent $event): void
	{
		$orderId = (int) $event->presenter->getParameter('id');

		if ($event->key !== self::SIGNAL_KEY) {
			return;
		}

		$this->orderSales->sendDiscountCoupons($this->orderSales->getDiscountsPurchasedInOrder($orderId));
		$event->presenter->flashMessageSuccess('eshopSales.orderForm.discountCouponsSend');
		$event->presenter->redrawControl('flashes');
	}

}
