<?php declare(strict_types=1);

namespace EshopSales\FrontModule\Components\Order;

use Core\Model\UI\BaseControl;
use Core\Model\UI\Form\BaseForm;
use EshopSales\FrontModule\Model\OrderSales;
use EshopSales\Model\Entities\OrderSale;
use Nette\Utils\ArrayHash;

class DiscountDetailItem extends BaseControl
{
	/** @var OrderSale */
	protected $orderSale;

	/** @var OrderSales */
	protected $orderSales;

	/**
	 * DiscountDetailItem constructor.
	 * @param OrderSale $orderSale
	 * @param OrderSales $orderSales
	 */
	public function __construct(OrderSale $orderSale, OrderSales $orderSales)
	{
		parent::__construct();
		$this->orderSale = $orderSale;
		$this->orderSales = $orderSales;
	}

	/**
	 * @return BaseForm
	 */
	public function createComponentItemForm(): BaseForm
	{
		$form = $this->createForm();
		$form->setAjax();
		$form->addHidden('orderSaleId')
			 ->setDefaultValue($this->orderSale->getId())
			 ->setRequired();

		if (!$this->orderSale->isAutoSale()) {
			$form->addSubmit('submitRemove');
		}

		$form->onSuccess[] = [$this, 'formSuccess'];

		return $form;
	}

	/**
	 * @param BaseForm $form
	 * @param ArrayHash $values
	 */
	public function formSuccess(BaseForm $form, ArrayHash $values): void
	{
		if ($form['submitRemove']->isSubmittedBy()) {
			$this->orderSales->removeFromCart((int) $values->orderSaleId);
		}

		$this->eventDispatcher->dispatch('eshopSales.discountCodesChanged');
	}

	public function render(): void
	{
		$this->template->item = $this->orderSale;
		$this->template->render($this->getTemplateFile());
	}

}