<?php declare(strict_types=1);

namespace EshopSales\FrontModule\Components\Order;

use Core\Model\UI\BaseControl;
use EshopOrders\FrontModule\Model\Carts;
use EshopSales\FrontModule\Model\OrderSales;
use Exception;
use Nette\Application\UI\Multiplier;

class DiscountsGrid extends BaseControl
{
	/** @var OrderSales */
	protected $orderSales;

	/** @var IDiscountDetailItemFactory */
	protected $discountDetailItemFactory;

	/** @var Carts */
	protected $carts;

	/**
	 * DiscountsGrid constructor.
	 * @param OrderSales $orderSales
	 * @param IDiscountDetailItemFactory $discountDetailItemFactory
	 * @param Carts $carts
	 */
	public function __construct(OrderSales $orderSales, IDiscountDetailItemFactory $discountDetailItemFactory, Carts $carts)
	{
		parent::__construct();
		$this->orderSales = $orderSales;
		$this->discountDetailItemFactory = $discountDetailItemFactory;
		$this->carts = $carts;
	}

	/**
	 * @return Multiplier
	 */
	public function createComponentDiscountDetailItem(): Multiplier
	{
		$factory = $this->discountDetailItemFactory;
		return new Multiplier(function (int $id) use ($factory) {
			$orderSale = $this->orderSales->get($id);
			return $factory->create($orderSale);
		});
	}

	/**
	 * @throws Exception
	 */
	public function render(): void
	{
		$this->template->items = $this->orderSales->getOrderSalesFromCart($this->carts->getCurrentCart()->getCartItemsPrice());
		$this->template->render($this->getTemplateFile());
	}

}