<?php declare(strict_types=1);

namespace EshopSales\FrontModule\Components\Order;

use Core\Model\UI\BaseControl;
use Core\Model\UI\Form\BaseForm;
use EshopSales\FrontModule\Model\CartSales;
use EshopSales\Model\Entities\OrderSale;
use Nette\Utils\ArrayHash;

class DiscountDetailItem extends BaseControl
{
	/** @var OrderSale */
	protected $orderSale;

	/** @var OrderSale */
	protected $cartSales;

	/**
	 * DiscountDetailItem constructor.
	 * @param OrderSale $orderSale
	 * @param CartSales $cartSales
	 */
	public function __construct(OrderSale $orderSale, CartSales $cartSales)
	{
		parent::__construct();
		$this->orderSale = $orderSale;
		$this->cartSales = $cartSales;
	}

	/**
	 * @return BaseForm
	 */
	public function createComponentItemForm(): BaseForm
	{
		$form = $this->createForm();
		$form->setAjax();
		$form->addHidden('orderSaleCode')
			 ->setDefaultValue($this->orderSale->code)
			 ->setRequired();

		$form->addSubmit('submitRemove');

		$form->onSuccess[] = [$this, 'formSuccess'];

		return $form;
	}

	/**
	 * @param BaseForm $form
	 * @param ArrayHash $values
	 */
	public function formSuccess(BaseForm $form, ArrayHash $values): void
	{
		if ($form['submitRemove']->isSubmittedBy()) {
			$this->cartSales->removeFromCart($values->orderSaleCode);
		}

		$this->eventDispatcher->dispatch('eshopSales.discountCodesChanged');
	}

	public function render(): void
	{
		$this->template->item = $this->orderSale;
		$this->template->render($this->getTemplateFile());
	}

}