<?php declare(strict_types=1);

namespace EshopSales\FrontModule\Components\Order;

use Core\Model\UI\BaseControl;
use EshopOrders\FrontModule\Model\Carts;
use EshopSales\FrontModule\Model\CartSales;
use EshopSales\FrontModule\Model\OrderSales;
use Exception;
use Nette\Application\UI\Multiplier;

class DiscountsGrid extends BaseControl
{
	/** @var CartSales */
	protected $cartSales;

	/** @var IDiscountDetailItemFactory */
	protected $discountDetailItemFactory;

	/** @var Carts */
	protected $carts;

	/**
	 * DiscountsGrid constructor.
	 * @param CartSales $cartSales
	 * @param IDiscountDetailItemFactory $discountDetailItemFactory
	 * @param Carts $carts
	 */
	public function __construct(CartSales $cartSales, IDiscountDetailItemFactory $discountDetailItemFactory, Carts $carts)
	{
		parent::__construct();
		$this->cartSales = $cartSales;
		$this->discountDetailItemFactory = $discountDetailItemFactory;
		$this->carts = $carts;
	}

	/**
	 * @return Multiplier
	 */
	public function createComponentDiscountDetailItem(): Multiplier
	{
		$factory = $this->discountDetailItemFactory;
		return new Multiplier(function (int $id) use ($factory) {
			$orderSale = $this->cartSales->get($id);
			return $factory->create($orderSale);
		});
	}

	/**
	 * @throws Exception
	 */
	public function render(): void
	{
		$this->template->items = $this->cartSales->getOrderSalesFromCart($this->carts->getCurrentCart()->getCartItemsPrice());
		$this->template->render($this->getTemplateFile());
	}

}