<?php declare(strict_types = 1);

namespace EshopSales\FrontModule\Model;

use Core\Model\Helpers\BaseFrontEntityService;
use EshopSales\Model\Entities\OrderSale;
use Nette\Utils\DateTime;

class OrderSales extends BaseFrontEntityService
{
	/** @var array */
	protected $cAutoSales;

	/** @var string */
	protected $entityClass = OrderSale::class;

	public function getAutoSales(): array
	{
		if ($this->cAutoSales === null) {
			$today  = new DateTime();
			$result = [];

			foreach ($this->getEr()->createQueryBuilder('os')->where('os.code IS NULL')->andWhere('os.isActive = 1')
				         ->andWhere('os.dateFrom >= :today OR os.dateFrom IS NULL')->andWhere('os.dateTo <= :today OR os.dateTo IS NULL')
				         ->setParameter('today', $today)
				         ->orderBy('os.fromPrice', 'ASC')->getQuery()->getArrayResult() as $row) {
				$row['fromPrice']  = (float) $row['fromPrice'];
				$row['amount']     = (float) $row['amount'];
				$row['typeSymbol'] = OrderSale::TYPES[$row['type']]['symbol'];
				$result[]          = $row;
			}

			$this->cAutoSales = $result;
		}

		return $this->cAutoSales;
	}

	public function getNextSales(float $cartItemsPrice): array
	{
		$result    = [];
		$autoSales = $this->getAutoSales();

		foreach ($autoSales as $k => $sale) {
			if ($cartItemsPrice >= $sale['fromPrice'])
				continue;

			$result[] = $sale;
		}

		return $result;
	}
}
