<?php declare(strict_types=1);

namespace EshopSales\Model\Listeners;

use Doctrine\ORM\Event\PreUpdateEventArgs;
use Doctrine\ORM\Mapping as ORM;
use EshopSales\Model\Entities\OrderSale;
use Nette\Utils\Validators;

class OrderSaleListener
{
	/**
	 * @ORM\PreUpdate
	 * @param OrderSale $orderSale
	 * @param PreUpdateEventArgs $event
	 */
	public function preUpdate(OrderSale $orderSale, PreUpdateEventArgs $event): void
	{
		$maxRepetitionsField = 'maxRepetitions';

		if ($event->hasChangedField($maxRepetitionsField)) {
			$maxRepetitionsFieldOldValue = $event->getOldValue($maxRepetitionsField);
			$maxRepetitionsFieldNewValue = $event->getNewValue($maxRepetitionsField);

			if ($maxRepetitionsFieldOldValue === null
				|| $orderSale->currentRepetitions === null
				|| $maxRepetitionsFieldNewValue < $orderSale->currentRepetitions
				|| $maxRepetitionsFieldNewValue === null)
			{
				$orderSale->currentRepetitions = $event->getNewValue($maxRepetitionsField);
			} elseif (
				Validators::isNumber($maxRepetitionsFieldOldValue)
				&& Validators::isNumber($maxRepetitionsFieldNewValue)
				&& ($maxRepetitionsFieldNewValue > $maxRepetitionsFieldOldValue)
			) {
				// increases the original value by the difference between the original value and the new value
				$orderSale->currentRepetitions += $maxRepetitionsFieldNewValue - $maxRepetitionsFieldOldValue;
			}
		}
	}
}