<?php declare(strict_types=1);

namespace EshopSales\Model\Templating\Filters;

use EshopSales\Model\Entities\OrderSale;
use EshopSales\Model\Utils\Helpers;

class Amount
{
	/** @var Helpers */
	protected $helpers;

	/**
	 * Amount constructor.
	 * @param Helpers $helpers
	 */
	public function __construct(Helpers $helpers)
	{
		$this->helpers = $helpers;
	}

	/**
	 * @param OrderSale $orderSale
	 * @return string
	 */
	public function __invoke(OrderSale $orderSale): string
	{
		return $this->helpers->formatAmount($orderSale);
	}
}