<?php declare(strict_types=1);

namespace EshopSales\Model\Utils;

use Core\Model\Templating\Filters\Price;
use EshopSales\Model\Entities\OrderSale;

class Helpers
{
	/** @var Price */
	protected $priceFilter;

	/**
	 * Helpers constructor.
	 * @param Price $priceFilter
	 */
	public function __construct(Price $priceFilter)
	{
		$this->priceFilter = $priceFilter;
	}

	/**
	 * @param OrderSale $orderSale
	 * @return string
	 */
	public function formatAmount(OrderSale $orderSale): string
	{
		if ($orderSale->getType() === OrderSale::TYPE_FIX) {
			return $this->priceFilter->format($orderSale->getAmount());
		}

		// type percent
		return sprintf('%s %s', $orderSale->getAmount(), '%');
	}

}