<?php declare(strict_types = 1);

namespace EshopStatistics\AdminModule\Model\Subscribers;

use Core\Model\Event\ControlEvent;
use EshopOrders\AdminModule\Presenters\AdminToolsPresenter;
use Override;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class PresenterSubscriber implements EventSubscriberInterface
{
	#[Override]
	public static function getSubscribedEvents(): array
	{
		return [
			AdminToolsPresenter::class . '::actiondefault' => 'actionDefault',
		];
	}

	public function actionDefault(ControlEvent $event): void
	{
		/** @var AdminToolsPresenter $presenter */
		$presenter = $event->control;

		$presenter->adminToolsUrlFiles[] = __DIR__ . DS . 'adminToolsPpc.latte';
		$presenter->adminToolsUrlFiles[] = __DIR__ . DS . 'adminToolsProducts.latte';
		$presenter->adminToolsUrlFiles[] = __DIR__ . DS . 'adminToolsZboziReport.latte';
		$presenter->adminToolsUrlFiles[] = __DIR__ . DS . 'adminToolsZboziAggregatedReport.latte';
	}
}
