<?php declare(strict_types = 1);

namespace EshopStatistics\AdminModule\Presenters;

use Nette\Application\BadRequestException;
use Override;

abstract class BasePresenter extends \Core\AdminModule\Presenters\BasePresenter
{
	/**
	 * @param mixed $element
	 *
	 * @throws BadRequestException
	 */
	#[Override]
	public function checkRequirements($element): void
	{
		parent::checkRequirements($element);
		if (!$this->getUser()->isAllowed($this->getFullModuleName(), 'access')) {
			$this->error();
		}
	}

	/**
	 * @return void
	 */
	#[Override]
	protected function startup()
	{
		set_time_limit(120);
		parent::startup(); // TODO: Change the autogenerated stub
	}

}
