<?php declare(strict_types = 1);

namespace EshopStatistics\AdminModule\Presenters;

use EshopStatistics\AdminModule\Components\Customer\CustomerStatisticsGrid;
use EshopStatistics\AdminModule\Components\Customer\ICustomerStatisticsGridFactory;
use EshopStatistics\Model\EshopStatisticsConfig;
use Override;

class CustomerPresenter extends BasePresenter
{
	protected const ICON = 'fas fa-chart-bar';

	/**
	 * @return void
	 */
	#[Override]
	protected function startup()
	{
		parent::startup();
		$withoutVat = EshopStatisticsConfig::load('priceWithoutVat', false);
		$this->setHeader('eshopStatistics.title.customerStatistics', self::ICON, $withoutVat ? 'eshopStatistics.titleDesc.withoutVat' : '');
	}

	/*******************************************************************************************************************
	 * ============================== Actions
	 */

	public function actionDefault(): void
	{
	}

	/*******************************************************************************************************************
	 * ============================== Components
	 */

	protected function createComponentCustomerStatisticsGrid(ICustomerStatisticsGridFactory $factory): CustomerStatisticsGrid
	{
		return $factory->create();
	}
}
