<?php declare(strict_types = 1);

namespace EshopStatistics\AdminModule\Presenters;


use EshopStatistics\AdminModule\Components\Supplier\ISupplierStatisticsGridFactory;
use EshopStatistics\AdminModule\Components\Supplier\SupplierStatisticsGrid;
use EshopStatistics\Model\EshopStatisticsConfig;
use EshopStock\DI\EshopStockExtension;
use Override;

class SupplierPresenter extends BasePresenter
{
	protected const ICON = 'fas fa-chart-bar';

	/**
	 * @return void
	 */
	#[Override]
	protected function startup()
	{
		parent::startup();
		$withoutVat = EshopStatisticsConfig::load('priceWithoutVat', false);
		if (class_exists(EshopStockExtension::class)) {
			parent::startup();
			$this->setHeader('eshopStatistics.title.supplierStatistics', self::ICON, $withoutVat ? 'eshopStatistics.titleDesc.withoutVat' : '');
		} else {
			$this->setHeader('eshopStatistics.title.stockModuleNotFound', self::ICON, $withoutVat ? 'eshopStatistics.titleDesc.withoutVat' : '');
		}
	}

	/*******************************************************************************************************************
	 * ============================== Actions
	 */

	public function actionDefault(): void
	{
	}

	/*******************************************************************************************************************
	 * ============================== Components
	 */

	protected function createComponentSupplierStatisticsGrid(ISupplierStatisticsGridFactory $factory): SupplierStatisticsGrid
	{
		return $factory->create();
	}
}
