<?php declare(strict_types = 1);

namespace EshopStatistics\Console;

use Doctrine;
use EshopStatistics\Model\ZboziItemReportService;
use Exception;
use Override;
use Symfony\Component\Console\Attribute\AsCommand;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;

#[AsCommand(name: 'eshop-statistics:download-zbozi-item-report')]
class ZboziItemReport extends Command
{
	public function __construct(
		public ZboziItemReportService $zboziItemReportService,
	)
	{
		parent::__construct();
	}

	#[Override]
	protected function configure(): void
	{
		$this->setName('eshop-statistics:download-zbozi-item-report')
			->addOption('monthModifier', null, InputOption::VALUE_OPTIONAL)
			->setDescription('Download zbozi item report');
	}

	#[Override]
	protected function execute(
		InputInterface  $input,
		OutputInterface $output,
	): int
	{
		$output->writeln('Start downloading');

		try {
			$monthModifier = $input->getOption('monthModifier') ?: '-1 month';

			$this->zboziItemReportService->downloadLastMonth($monthModifier);

			$output->writeLn('<info>[OK]</info>');

			return 0;
		} catch (Exception $e) {
			$output->writeln('<error>[ERROR] - ' . $e->getMessage() . '</error>');
		}

		return 1;
	}

}
