<?php declare(strict_types = 1);

namespace EshopStatistics\Model\Entities;

use Core\Model\Entities\TIdUnsigned;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table('eshop_statistics__zbozi_item_report')]
#[ORM\Entity]
class ZboziItemReport
{
	use TIdUnsigned;

	#[ORM\JoinColumn(nullable: false, onDelete: 'CASCADE')]
	#[ORM\ManyToOne(targetEntity: ZboziReport::class)]
	public ZboziReport $zboziReport;

	#[ORM\Column(type: Types::INTEGER, nullable: false, options: ['unsigned' => true])]
	public int $itemId;

	#[ORM\Column(type: Types::STRING, length: 255, nullable: true)]
	public string $itemName;

	#[ORM\Column(type: Types::INTEGER, nullable: true, options: ['unsigned' => true])]
	public int $views;

	#[ORM\Column(type: Types::INTEGER, nullable: true, options: ['unsigned' => true])]
	public int $clicks;

	#[ORM\Column(type: Types::INTEGER, nullable: true, options: ['unsigned' => true])]
	public ?int $costs = 0;

	#[ORM\Column(type: Types::INTEGER, nullable: true, options: ['unsigned' => true])]
	public int $conversions;

	#[ORM\Column(type: Types::INTEGER, nullable: true, options: ['unsigned' => true])]
	public int $conversionsValue;

	public function __construct(ZboziReport $zboziReport, int $itemId)
	{
		$this->zboziReport = $zboziReport;
		$this->itemId      = $itemId;
	}
}
