<?php declare(strict_types = 1);

namespace EshopStatistics\Model\Entities;

use DateTimeInterface;
use Core\Model\Entities\TIdUnsigned;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table('eshop_statistics__zbozi_report')]
#[ORM\Entity]
class ZboziReport
{
	use TIdUnsigned;

	#[ORM\Column(type: Types::STRING, length: 255, nullable: false)]
	public string $siteIdent;

	#[ORM\Column(type: Types::INTEGER, nullable: false, options: ['unsigned' => true])]
	public int $requestId;

	#[ORM\Column(type: Types::DATE_MUTABLE, nullable: false)]
	public DateTimeInterface $from;

	#[ORM\Column(type: Types::DATE_MUTABLE, nullable: false)]
	public DateTimeInterface $to;

	public function __construct(string $siteIdent, int $requestId, DateTimeInterface $from, DateTimeInterface $to)
	{
		$this->siteIdent = $siteIdent;
		$this->requestId = $requestId;
		$this->from      = $from;
		$this->to        = $to;
	}
}
