<?php declare(strict_types = 1);

namespace EshopStatistics\AdminModule\Components\Payment;

use Core\Model\UI\BaseControl;
use Core\Model\UI\DataGrid\BaseDataGrid;
use Core\Model\UI\Form\BaseForm;
use DateTime;
use DateTimeInterface;
use EshopOrders\AdminModule\Model\Payments;
use EshopStatistics\AdminModule\Model\OrderStatistics;
use Nette\Utils\ArrayHash;
use Ublaboo\DataGrid\DataSource\ArrayDataSource;

class PaymentStatisticsGrid extends BaseControl
{
	protected OrderStatistics $orderStatistics;
	protected Payments $payments;
	protected DateTimeInterface $from;
	protected DateTimeInterface $to;

	public function __construct(OrderStatistics $orderStatistics, Payments $payments)
	{
		$this->orderStatistics = $orderStatistics;
		$this->payments        = $payments;

		$this->from = (new DateTime)->modify('-1 year');
		$this->to   = (new DateTime);
	}

	public function render(): void
	{
		$this->template->render($this->getTemplateFile());
	}

	/*******************************************************************************************************************
	 * ======================== Components
	 */

	protected function createComponentFromToForm(): BaseForm
	{
		//TODO tohle do nejakyho iFacu nebo predka, kdyz je to ve vsech stejny - a kdyz to bude podrobnejsi, tak se to proste implementuje jinak. Tak traitu nebo co, interface jen deklaruje ale nedefinuje
		$form = $this->createForm();
		$form->setAjax();

		$form->addDatePicker('from', '')
			->setHtmlAttribute('data-type', 'yearMonth')
			->setHtmlAttribute('onChange', 'window.naja.uiHandler.submitForm(this.form)')
			->setDefaultValue($this->from);
		$form->addDatePicker('to', '')
			->setHtmlAttribute('data-type', 'yearMonth')
			->setHtmlAttribute('onChange', 'window.naja.uiHandler.submitForm(this.form)')
			->setDefaultValue($this->to);

		$form->addSubmit('update', 'default.update');

		$form->onSuccess[] = function(BaseForm $form, ArrayHash $values) {
			$this->from = $values->from;
			$this->to   = $values->to;

			$this['grid']->reload();
		};

		return $form;
	}

	protected function createComponentGrid(): BaseDataGrid
	{
		$grid = $this->createGrid();
		$grid->setTemplateFile(__DIR__ . '/../StatisticsGridHeader_grid.latte');

		$grid->setDataSource(new ArrayDataSource($this->orderStatistics->getMonthlyByCarrier($this->from, $this->to)));

		$summaryCols = ['payment-count-total', 'payment-price-total'];

		// Columns
		$grid->addColumnDateTime('date', 'eshopStatistics.orderStatistics.monthlyOrders.date')->setFormat('m/Y')->addCellAttributes(['class' => 'border-right-stronger'])->setTemplate(null, ['supHeaderGroup' => 'date']);
		$grid->addColumnNumber('payment-count-total', 'eshopStatistics.orderStatistics.monthlyOrders.ordersCount')->setFormat(0, '', ' ')->setTemplate(null, ['supHeaderText'  => $this->translator->translate('eshopStatistics.orderStatistics.monthlyOrders.total'),
		                                                                                                                                                     'supHeaderGroup' => 'total']);
		$grid->addColumnNumber('payment-price-total', 'eshopStatistics.orderStatistics.monthlyOrders.ordersPrice')->setFormat(2, ',', ' ')->addCellAttributes(['class' => 'price border-right-stronger'])->setTemplate(null, ['supHeaderGroup' => 'total']);

		foreach ($this->payments->getForSelectOption() as $k => $v) {
			$paymentName = $v;
			$paymentId   = $k;

			$grid->addColumnNumber('payment-count-' . $paymentId, 'eshopStatistics.orderStatistics.monthlyOrders.ordersCount')->setFormat(0, '', ' ')->setTemplate(null, ['supHeaderText'  => $paymentName,
			                                                                                                                                                              'supHeaderGroup' => $paymentId]);
			$grid->addColumnNumber('payment-price-' . $paymentId, 'eshopStatistics.orderStatistics.monthlyOrders.ordersPrice')->setFormat(2, ',', ' ')->addCellAttributes(['class' => 'price border-right-stronger'])->setTemplate(null, ['supHeaderGroup' => $paymentId]);
			$summaryCols[] = 'payment-count-' . $paymentId;
			$summaryCols[] = 'payment-price-' . $paymentId;
		}

		$grid->setColumnsSummary($summaryCols);

		return $grid;
	}
}
