<?php declare(strict_types = 1);

namespace EshopStatistics\AdminModule\Presenters;

use Nette\Application\BadRequestException;

abstract class BasePresenter extends \Core\AdminModule\Presenters\BasePresenter
{
	/**
	 * @param mixed $element
	 * @throws BadRequestException
	 */
	public function checkRequirements($element): void
	{
		parent::checkRequirements($element);
		if (!$this->getUser()->isAllowed($this->getFullModuleName(), 'access')) {
			$this->error();
		}
	}

	/**
	 * @return void
	 */
	protected function startup()
	{
		set_time_limit(120);
		parent::startup(); // TODO: Change the autogenerated stub
		$this->em->getConnection()->getConfiguration()->setSQLLogger(null);
	}

}
