<?php declare(strict_types = 1);

namespace EshopStatistics\AdminModule\Presenters;

use EshopStatistics\AdminModule\Components\Customer\ICustomerStatisticsGridFactory;
use EshopStatistics\AdminModule\Components\Customer\CustomerStatisticsGrid;
use EshopStatistics\Model\EshopStatisticsConfig;

class CustomerPresenter extends BasePresenter
{
	protected const ICON = 'fas fa-chart-bar';

	/**
	 * @return void
	 */
	protected function startup()
	{
		parent::startup();
		$withoutVat = EshopStatisticsConfig::load('priceWithoutVat', false);
		$this->setHeader('eshopStatistics.title.customerStatistics', self::ICON, $withoutVat ? 'eshopStatistics.titleDesc.withoutVat' : '');
	}

	/*******************************************************************************************************************
	 * ============================== Actions
	 */

	public function actionDefault(): void
	{
	}

	/*******************************************************************************************************************
	 * ============================== Components
	 */

	protected function createComponentCustomerStatisticsGrid(ICustomerStatisticsGridFactory $factory): CustomerStatisticsGrid
	{
		return $factory->create();
	}
}
