<?php declare(strict_types = 1);

namespace EshopStatistics\AdminModule\Presenters;

use EshopStatistics\AdminModule\Components\Orders\IOrderByCountryStatisticsGridFactory;
use EshopStatistics\AdminModule\Components\Orders\IOrderStatisticsDailyGridFactory;
use EshopStatistics\AdminModule\Components\Orders\IOrderStatisticsGridFactory;
use EshopStatistics\AdminModule\Components\Orders\OrderByCountryStatisticsGrid;
use EshopStatistics\AdminModule\Components\Orders\OrderStatisticsDailyGrid;
use EshopStatistics\AdminModule\Components\Orders\OrderStatisticsGrid;
use EshopStatistics\Model\EshopStatisticsConfig;

class DefaultPresenter extends BasePresenter
{
	protected const ICON = 'fas fa-chart-bar';

	/**
	 * @return void
	 */
	protected function startup()
	{
		parent::startup();
		$withoutVat = EshopStatisticsConfig::load('priceWithoutVat', false);
		$this->setHeader('eshopStatistics.title.statistics', self::ICON, $withoutVat ? 'eshopStatistics.titleDesc.withoutVat' : '');
	}

	/*******************************************************************************************************************
	 * ============================== Actions
	 */

	public function actionDefault(): void
	{
	}

	/*******************************************************************************************************************
	 * ============================== Components
	 */

	protected function createComponentOrderStatisticsGrid(IOrderStatisticsGridFactory $factory): OrderStatisticsGrid
	{
		return $factory->create();
	}

	protected function createComponentOrderByCountryStatisticsGrid(IOrderByCountryStatisticsGridFactory $factory): OrderByCountryStatisticsGrid
	{
		return $factory->create();
	}

	protected function createComponentOrderStatisticsDailyGrid(IOrderStatisticsDailyGridFactory $factory): OrderStatisticsDailyGrid
	{
		return $factory->create();
	}
}
