<?php declare(strict_types = 1);

namespace EshopStatistics\Console;

use Doctrine;
use Doctrine\ORM\Tools\Console\Command\SchemaTool\AbstractCommand;
use EshopStatistics\Model\ZboziAggregatedReportService;
use Exception;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Style\SymfonyStyle;

class ZboziAggregatedReport extends AbstractCommand
{
	/** @var ZboziAggregatedReportService|null @inject */
	public ?ZboziAggregatedReportService $zboziAggregatedReportService = null;

	protected function configure(): void
	{
		$this->setName('eshop-statistics:download-zbozi-aggregated-report')
			->addOption('dayModifier', null, InputOption::VALUE_OPTIONAL)
			->addOption('days', null, InputOption::VALUE_OPTIONAL)
			->setDescription('Download zbozi aggregated report');
	}

	protected function executeSchemaCommand(InputInterface $input, OutputInterface $output, Doctrine\ORM\Tools\SchemaTool $schemaTool, array $metadatas, SymfonyStyle $ui): int
	{
		$output->writeln('Start downloading');

		try {
			$dayModifier = $input->getOption('dayModifier') ?: '-1 day';
			$days        = $input->getOption('days') ?: 1;

			$this->zboziAggregatedReportService->downloadLastDay($dayModifier, (int) $days);

			$output->writeLn('<info>[OK]</info>');

			return 0;
		} catch (Exception $e) {
			$output->writeln('<error>[ERROR] - ' . $e->getMessage() . '</error>');
		}

		return 1;
	}

}
