<?php declare(strict_types = 1);

namespace EshopStatistics\Console;

use Doctrine;
use Doctrine\ORM\Tools\Console\Command\SchemaTool\AbstractCommand;
use EshopStatistics\Model\ZboziItemReportService;
use Exception;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Style\SymfonyStyle;

class ZboziItemReport extends AbstractCommand
{
	/** @var ZboziItemReportService|null @inject */
	public ?ZboziItemReportService $zboziItemReportService = null;

	protected function configure(): void
	{
		$this->setName('eshop-statistics:download-zbozi-item-report')
			->addOption('monthModifier', null, InputOption::VALUE_OPTIONAL)
			->setDescription('Download zbozi item report');
	}

	protected function executeSchemaCommand(InputInterface $input, OutputInterface $output, Doctrine\ORM\Tools\SchemaTool $schemaTool, array $metadatas, SymfonyStyle $ui): int
	{
		$output->writeln('Start downloading');

		try {
			$monthModifier = $input->getOption('monthModifier') ?: '-1 month';

			$this->zboziItemReportService->downloadLastMonth($monthModifier);

			$output->writeLn('<info>[OK]</info>');

			return 0;
		} catch (Exception $e) {
			$output->writeln('<error>[ERROR] - ' . $e->getMessage() . '</error>');
		}

		return 1;
	}

}
