<?php declare(strict_types = 1);

namespace EshopStatistics\DI;

use Core\DI\CompilerExtension;
use Nette;

class EshopStatisticsExtension extends CompilerExtension
{

	public function loadConfiguration()
	{
		parent::loadConfiguration();
		$this->setConfig($this->loadFromFile(__DIR__ . '/config.neon'));

		$this->compiler->loadDefinitionsFromConfig($this->loadFromFile(__DIR__ . '/services.neon'));
	}

	public function beforeCompile()
	{
		parent::beforeCompile();
		$this->setMapping(['EshopStatistics' => 'EshopStatistics\*Module\Presenters\*Presenter']);
	}

	public function afterCompile(Nette\PhpGenerator\ClassType $class)
	{
		parent::afterCompile($class);
		$init    = $class->methods["initialize"];
		$builder = $this->getContainerBuilder();

		$password = new Nette\Security\Passwords();

		$init->addBody('EshopStatistics\Model\EshopStatisticsConfig::setParams($this->parameters[\'eshopStatistics\']);');
	}
}
