<?php declare(strict_types = 1);

namespace EshopStatistics\Model\Entities;

use Core\Model\Entities\TIdUnsigned;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table("eshop_statistics__zbozi_aggregated_report")
 * @ORM\Entity
 */
class ZboziAggregatedReport
{
	use TIdUnsigned;

	/**
	 * @ORM\Column(type="string", length=255, nullable=false)
	 */
	public string $siteIdent;

	/**
	 * @ORM\Column(type="date", nullable=false)
	 */
	public \DateTimeInterface $day;

	/**
	 * @ORM\Column(type="integer", options={"unsigned":true}, nullable=true)
	 */
	public ?int $views = null;

	/**
	 * @ORM\Column(type="integer", options={"unsigned":true}, nullable=true)
	 */
	public ?int $clicks = null;

	/**
	 * @ORM\Column(type="integer", options={"unsigned":true}, nullable=true)
	 */
	public ?int $costs = null;

	/**
	 * @ORM\Column(type="integer", options={"unsigned":true}, nullable=true)
	 */
	public ?int $conversions = null;

	/**
	 * @ORM\Column(type="integer", options={"unsigned":true}, nullable=true)
	 */
	public ?int $conversionsValue = null;

	public function __construct(string $siteIdent, \DateTimeInterface $day)
	{
		$this->siteIdent = $siteIdent;
		$this->day       = $day;
	}
}
