<?php declare(strict_types = 1);

namespace EshopStatistics\Model\Entities;

use Core\Model\Entities\TIdUnsigned;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table("eshop_statistics__zbozi_item_report")
 * @ORM\Entity
 */
class ZboziItemReport
{
	use TIdUnsigned;

	/**
	 * @ORM\ManyToOne(targetEntity="ZboziReport")
	 * @ORM\JoinColumn(nullable=false, onDelete="CASCADE")
	 */
	public ZboziReport $zboziReport;

	/**
	 * @ORM\Column(type="integer", options={"unsigned":true}, nullable=false)
	 */
	public int $itemId;

	/**
	 * @ORM\Column(type="string", length=255, nullable=true)
	 */
	public string $itemName;

	/**
	 * @ORM\Column(type="integer", options={"unsigned":true}, nullable=true)
	 */
	public int $views;

	/**
	 * @ORM\Column(type="integer", options={"unsigned":true}, nullable=true)
	 */
	public int $clicks;

	/**
	 * @ORM\Column(type="integer", options={"unsigned":true}, nullable=true)
	 */
	public int $costs;

	/**
	 * @ORM\Column(type="integer", options={"unsigned":true}, nullable=true)
	 */
	public int $conversions;

	/**
	 * @ORM\Column(type="integer", options={"unsigned":true}, nullable=true)
	 */
	public int $conversionsValue;

	public function __construct(ZboziReport $zboziReport, int $itemId)
	{
		$this->zboziReport = $zboziReport;
		$this->itemId      = $itemId;
	}
}
