<?php declare(strict_types = 1);

namespace EshopStatistics\Model\Entities;

use Core\Model\Entities\TIdUnsigned;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table("eshop_statistics__zbozi_report")
 * @ORM\Entity
 */
class ZboziReport
{
	use TIdUnsigned;

	/**
	 * @ORM\Column(type="string", length=255, nullable=false)
	 */
	public string $siteIdent;

	/**
	 * @ORM\Column(type="integer", options={"unsigned":true}, nullable=false)
	 */
	public int $requestId;

	/**
	 * @ORM\Column(type="datetime", nullable=false)
	 */
	public \DateTimeInterface $from;

	/**
	 * @ORM\Column(type="datetime", nullable=false)
	 */
	public \DateTimeInterface $to;

	public function __construct(string $siteIdent, int $requestId, \DateTimeInterface $from, \DateTimeInterface $to)
	{
		$this->siteIdent = $siteIdent;
		$this->requestId = $requestId;
		$this->from      = $from;
		$this->to        = $to;
	}
}
