<?php declare(strict_types = 1);

namespace EshopStatistics\AdminModule\Components\Spedition;

use Core\Model\UI\BaseControl;
use Core\Model\UI\DataGrid\BaseDataGrid;
use Core\Model\UI\Form\BaseForm;
use DateTime;
use DateTimeInterface;
use EshopOrders\AdminModule\Model\Speditions;
use EshopStatistics\AdminModule\Model\OrderStatistics;
use Nette\Utils\ArrayHash;
use Ublaboo\DataGrid\DataSource\ArrayDataSource;

class SpeditionStatisticsGrid extends BaseControl
{
	protected DateTimeInterface $from;
	protected DateTimeInterface $to;

	public function __construct(
		protected OrderStatistics $orderStatistics,
		protected Speditions      $speditions,
	)
	{
		$this->from = (new DateTime)->modify('-1 year');
		$this->to   = (new DateTime);
	}

	public function render(): void
	{
		$this->template->render($this->getTemplateFile());
	}

	/*******************************************************************************************************************
	 * ======================== Components
	 */

	protected function createComponentFromToForm(): BaseForm
	{
		$form = $this->createForm();
		$form->setAjax();

		$form->addDatePicker('from', '')
			->setHtmlAttribute('data-type', 'yearMonth')
			->setHtmlAttribute('onChange', 'window.naja.uiHandler.submitForm(this.form)')
			->setDefaultValue($this->from);
		$form->addDatePicker('to', '')
			->setHtmlAttribute('data-type', 'yearMonth')
			->setHtmlAttribute('onChange', 'window.naja.uiHandler.submitForm(this.form)')
			->setDefaultValue($this->to);

		$form->addSubmit('update', 'default.update');

		$form->onSuccess[] = function(BaseForm $form, ArrayHash $values): void {
			$this->from = $values->from;
			$this->to   = $values->to;

			$this['grid']->reload();
		};

		return $form;
	}

	protected function createComponentGrid(): BaseDataGrid
	{
		$grid = $this->createGrid();
		$grid->setTemplateFile(__DIR__ . '/../StatisticsGridHeader_grid.latte');

		$grid->setDataSource(new ArrayDataSource($this->orderStatistics->getMonthlyByCarrier($this->from, $this->to)));

		$summaryCols = ['spedition-count-total', 'spedition-price-total'];

		// Columns
		$grid->addColumnDateTime('date', 'eshopStatistics.orderStatistics.monthlyOrders.date')
			->setFormat('m/Y')
			->addCellAttributes(['class' => 'border-right-stronger'])
			->setTemplate(null, ['supHeaderGroup' => 'date']);
		$grid->addColumnNumber('spedition-count-total', 'eshopStatistics.orderStatistics.monthlyOrders.ordersCount')
			->setFormat(0, '', ' ')
			->setTemplate(null, [
				'supHeaderText'  => $this->translator->translate('eshopStatistics.orderStatistics.monthlyOrders.total'),
				'supHeaderGroup' => 'total',
			]);
		$grid->addColumnNumber('spedition-price-total', 'eshopStatistics.orderStatistics.monthlyOrders.ordersPrice')
			->setFormat(2, ',', ' ')
			->addCellAttributes(['class' => 'price border-right-stronger'])
			->setTemplate(null, ['supHeaderGroup' => 'total']);

		foreach ($this->speditions->getForSelectOption() as $k => $v) {
			$speditionName = $v;
			$speditionId   = $k;

			$grid->addColumnNumber('spedition-count-' . $speditionId, 'eshopStatistics.orderStatistics.monthlyOrders.ordersCount')
				->setFormat(0, '', ' ')->setTemplate(null, [
					'supHeaderText'  => $speditionName,
					'supHeaderGroup' => $speditionId,
				]);
			$grid->addColumnNumber('spedition-price-' . $speditionId, 'eshopStatistics.orderStatistics.monthlyOrders.ordersPrice')
				->setFormat(2, ',', ' ')
				->addCellAttributes(['class' => 'price border-right-stronger'])
				->setTemplate(null, ['supHeaderGroup' => $speditionId]);
			$summaryCols[] = 'spedition-count-' . $speditionId;
			$summaryCols[] = 'spedition-price-' . $speditionId;
		}

		$grid->setColumnsSummary($summaryCols);


		return $grid;
	}
}
