<?php declare(strict_types = 1);

namespace EshopStatistics\AdminModule\Components\Supplier;

use Core\Model\UI\BaseControl;
use Core\Model\UI\DataGrid\BaseDataGrid;
use Core\Model\UI\Form\BaseForm;
use DateTime;
use EshopStatistics\AdminModule\Model\SupplierStatistics;
use EshopStatistics\Model\EshopStatisticsConfig;
use EshopStock\DI\EshopStockExtension;
use Nette\Application\Attributes\Persistent;
use Nette\Utils\ArrayHash;

class SupplierStatisticsGrid extends BaseControl
{
	#[Persistent]
	public string $from;

	#[Persistent]
	public string $to;

	public function __construct(
		protected SupplierStatistics $supplierStatistics,
	)
	{
		$this->from = (new DateTime)->modify('-1 year')->format('Y-m-d');
		$this->to   = (new DateTime)->format('Y-m-d');
	}

	public function render(): void
	{
		if (class_exists(EshopStockExtension::class)) {
			$this->template->render($this->getTemplateFile());
		} else {
			$this->template->render($this->getTemplateFile('stockNotFound.latte'));
		}
	}

	/*******************************************************************************************************************
	 * ======================== Components
	 */

	protected function createComponentFilterForm(): BaseForm
	{
		$form = $this->createForm();
		$form->setAjax();

		$form->addDatePicker('from', '')
			->setHtmlAttribute('data-type', 'yearMonthDay')
			->setHtmlAttribute('onChange', '$(this.form).closest(\'form\').first().submit();') //TODO s naja se nacita nejaky jiny datepicker
			->setDefaultValue($this->from);
		$form->addDatePicker('to', '')
			->setHtmlAttribute('data-type', 'yearMonthDay')
			->setHtmlAttribute('onChange', '$(this.form).closest(\'form\').first().submit();')
			->setDefaultValue($this->to);

		$form->addSubmit('update', 'default.update');

		$form->onSuccess[] = function(BaseForm $form, ArrayHash $values): void {
			$this->from = $values->from->format('Y-m-d');
			$this->to   = $values->to->format('Y-m-d');

			$this['grid']->reload();
			$this->redrawControl('supplierStatisticsCard');
		};

		return $form;
	}

	protected function createComponentGrid(): BaseDataGrid
	{
		$grid = $this->createGrid();

		$configSort          = EshopStatisticsConfig::loadScalar('productStatisticGrid.sort');
		$configSortDirection = EshopStatisticsConfig::loadScalar('productStatisticGrid.sortDirection');
		$grid->setDefaultSort([$configSort => $configSortDirection]);

		$qb = $this->supplierStatistics->getBySupplier($this->from, $this->to);

		$grid->setDataSource($qb);

		// Columns
		$grid->addColumnLink('supplier_id', 'eshopStatistics.supplierStatistics.name', ':EshopCatalog:Admin:ManufacturersSuppliers:editSupplier', 'supplier_name', ['id' => 'supplier_id'])->setSortable()
			->setRenderer(fn($item) => $item['supplier_name'], fn($item): bool => $item['supplier_id'] == '');
		$grid->addColumnNumber('count_total', 'eshopStatistics.supplierStatistics.count')->setFormat(0, '', ' ')->setSortable();
		$grid->addColumnNumber('price_total', 'eshopStatistics.supplierStatistics.price')->setFormat(2, ',', ' ')->setSortable('price_sort');
		$grid->addColumnNumber('price_percent', 'eshopStatistics.supplierStatistics.pricePercent')->setFormat(1, ',', ' ');

		$grid->setColumnsSummary(['count_total', 'price_total']);

		return $grid;
	}
}
