<?php declare(strict_types = 1);

namespace EshopStatistics\AdminModule\Presenters;


use EshopStatistics\AdminModule\Components\Product\IProductStatisticsGridFactory;
use EshopStatistics\AdminModule\Components\Product\ProductStatisticsGrid;
use EshopStatistics\Model\EshopStatisticsConfig;
use Override;

class ProductPresenter extends BasePresenter
{
	protected const ICON = 'fas fa-chart-bar';

	/**
	 * @return void
	 */
	#[Override]
	protected function startup()
	{
		parent::startup();
		$withoutVat = EshopStatisticsConfig::load('priceWithoutVat', false);
		$this->setHeader('eshopStatistics.title.productStatistics', self::ICON, $withoutVat ? 'eshopStatistics.titleDesc.withoutVat' : '');
	}

	/*******************************************************************************************************************
	 * ============================== Actions
	 */

	public function actionDefault(): void
	{
	}

	/*******************************************************************************************************************
	 * ============================== Components
	 */

	protected function createComponentProductStatisticsGrid(IProductStatisticsGridFactory $factory): ProductStatisticsGrid
	{
		return $factory->create();
	}
}
