<?php declare(strict_types = 1);

namespace EshopStatistics\AdminModule\Presenters;

use EshopStatistics\AdminModule\Components\Payment\IPaymentStatisticsGridFactory;
use EshopStatistics\AdminModule\Components\Payment\PaymentStatisticsGrid;
use EshopStatistics\AdminModule\Components\Spedition\ISpeditionStatisticsGridFactory;
use EshopStatistics\AdminModule\Components\Spedition\SpeditionStatisticsGrid;
use EshopStatistics\Model\EshopStatisticsConfig;
use Override;

class SpeditionPresenter extends BasePresenter
{
	protected const ICON = 'fas fa-chart-bar';

	/**
	 * @return void
	 */
	#[Override]
	protected function startup()
	{
		parent::startup();
		$withoutVat = EshopStatisticsConfig::load('priceWithoutVat', false);
		$this->setHeader('eshopStatistics.title.speditionStatistics', self::ICON, $withoutVat ? 'eshopStatistics.titleDesc.withoutVat' : '');
	}

	/*******************************************************************************************************************
	 * ============================== Actions
	 */

	public function actionDefault(): void
	{
	}

	/*******************************************************************************************************************
	 * ============================== Components
	 */

	protected function createComponentSpeditionStatisticsGrid(ISpeditionStatisticsGridFactory $factory): SpeditionStatisticsGrid
	{
		return $factory->create();
	}

	protected function createComponentPaymentStatisticsGrid(IPaymentStatisticsGridFactory $factory): PaymentStatisticsGrid
	{
		return $factory->create();
	}

}
