<?php declare(strict_types = 1);

namespace EshopStatistics\Console;

use Doctrine;
use EshopStatistics\Model\ZboziAggregatedReportService;
use Exception;
use Override;
use Symfony\Component\Console\Attribute\AsCommand;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;

#[AsCommand(name: 'eshop-statistics:download-zbozi-aggregated-report')]
class ZboziAggregatedReport extends Command
{

	public function __construct(
		public ZboziAggregatedReportService $zboziAggregatedReportService,
	)
	{
		parent::__construct();
	}

	#[Override]
	protected function configure(): void
	{
		$this->setName('eshop-statistics:download-zbozi-aggregated-report')
			->addOption('dayModifier', null, InputOption::VALUE_OPTIONAL)
			->addOption('days', null, InputOption::VALUE_OPTIONAL)
			->setDescription('Download zbozi aggregated report');
	}

	#[Override]
	protected function execute(
		InputInterface  $input,
		OutputInterface $output,
	): int
	{
		$output->writeln('Start downloading');

		try {
			$dayModifier = $input->getOption('dayModifier') ?: '-1 day';
			$days        = $input->getOption('days') ?: 1;

			$this->zboziAggregatedReportService->downloadLastDay($dayModifier, (int) $days);

			$output->writeLn('<info>[OK]</info>');

			return 0;
		} catch (Exception $e) {
			$output->writeln('<error>[ERROR] - ' . $e->getMessage() . '</error>');
		}

		return 1;
	}

}
