<?php declare(strict_types = 1);

namespace EshopStatistics\Model\Entities;

use DateTimeInterface;
use Core\Model\Entities\TIdUnsigned;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table('eshop_statistics__zbozi_aggregated_report')]
#[ORM\Entity]
class ZboziAggregatedReport
{
	use TIdUnsigned;

	#[ORM\Column(type: Types::STRING, length: 255, nullable: false)]
	public string $siteIdent;

	#[ORM\Column(type: Types::DATE_MUTABLE, nullable: false)]
	public DateTimeInterface $day;

	#[ORM\Column(type: Types::INTEGER, nullable: true, options: ['unsigned' => true])]
	public ?int $views = null;

	#[ORM\Column(type: Types::INTEGER, nullable: true, options: ['unsigned' => true])]
	public ?int $clicks = null;

	#[ORM\Column(type: Types::INTEGER, nullable: true, options: ['unsigned' => true])]
	public ?int $costs = null;

	#[ORM\Column(type: Types::INTEGER, nullable: true, options: ['unsigned' => true])]
	public ?int $conversions = null;

	#[ORM\Column(type: Types::INTEGER, nullable: true, options: ['unsigned' => true])]
	public ?int $conversionsValue = null;

	public function __construct(string $siteIdent, DateTimeInterface $day)
	{
		$this->siteIdent = $siteIdent;
		$this->day       = $day;
	}
}
