<?php declare(strict_types = 1);

namespace EshopStock\Model\Entities;

use Core\Model\Entities\TId;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table('eshop_stock__stock')]
#[ORM\Entity]
class Stock
{
	use TId;

	#[ORM\Column(type: Types::STRING)]
	public string $name;

	/** @var Collection<Supply> */
	#[ORM\OneToMany(mappedBy: 'stock', targetEntity: Supply::class)]
	protected Collection $items;

	public function __construct(string $name)
	{
		$this->name  = $name;
		$this->items = new ArrayCollection;
	}

}
