<?php declare(strict_types = 1);

namespace EshopStock\AdminModule\Components;

use Core\Model\UI\BaseControl;
use Core\Model\UI\DataGrid\BaseDataGrid;
use EshopStock\Model\Entities\ProductsToOrderOrders;
use EshopStock\Model\Entities\ProductToOrder;
use EshopStock\Model\Entities\Stock;
use EshopStock\Model\Repository\ProductsToOrder;
use EshopStock\Model\Repository\Stocks;
use Nette\Utils\Html;

class DemandGrid extends BaseControl
{
	protected ProductsToOrder $productsToOrder;
	protected Stocks          $stocksService;
	protected Stock           $stock;

	public function __construct(
		int             $stockId,
		Stocks          $stocksService,
		ProductsToOrder $productsToOrder
	)
	{
		$this->stock           = $stocksService->get($stockId);
		$this->stocksService   = $stocksService;
		$this->productsToOrder = $productsToOrder;
	}

	public function createComponentGrid(): BaseDataGrid
	{
		$grid = $this->createGrid();
		$grid->setDataSource($this->productsToOrder->getQueryBuilder());

		$grid->addColumnText('code', 'eshopStock.demandGrid.code')
			->setRenderer(static function(ProductToOrder $productToOrder) {
				$p = $productToOrder->product;

				return implode(' / ', [$p->code1, $p->code2]);
			});
		$grid->addColumnText('name', 'eshopStock.demandGrid.name')
			->setRenderer(static function(ProductToOrder $productToOrder) {
				return $productToOrder->product->getText()->name;
			});
		$grid->addColumnNumber('quantity', 'eshopStock.demandGrid.quantity')
			->setFitContent();
		$grid->addColumnText('orders', 'eshopStock.demandGrid.orders')
			->setRenderer(function(ProductToOrder $productToOrder) {
				$orders = array_map(static fn(ProductsToOrderOrders $productsToOrderOrders) => $productsToOrderOrders->order->getId(), $productToOrder->orders->toArray());

				usort($orders, static fn($a, $b) => $b <=> $a);

				$output = [];
				foreach ($orders as $orderId) {
					$output[] = Html::el('a', [
						'href' => $this->presenter->link(':EshopOrders:Admin:Default:editOrder', $orderId),
					])->setText($orderId);
				}

				return implode(', ', $output);
			})->setTemplateEscaping(false);

		return $grid;
	}

	public function render(): void
	{
		$this->template->render($this->getTemplateFile());
	}

}
