<?php declare(strict_types=1);

namespace EshopStock\AdminModule\Components;

use Core\Model\UI\BaseControl;
use EshopStock\Model\Entities\Stock;
use EshopStock\Model\Repository\Stocks;
use EshopStock\Model\Repository\TemporarySupplyProducts;
use Nette\InvalidArgumentException;

class StocksTabs extends BaseControl
{
	/** @var Stock[] */
	protected array $stocks = [];
	protected Stocks $stocksService;
	protected Stock $activeStock;
    protected string $activeComponent;
	protected ISupplyFormFactory $supplyFormFactory;
	protected TemporarySupplyProducts $temporarySupplyProducts;
	protected IOverviewGridFactory $overviewGridFactory;
	protected IDemandGridFactory $demandGridFactory;
	protected IToDateFormFactory $toDateFormFactory;

	public function __construct(string $activeComponent, int $activeStockId, Stocks $stocksService,
	                            ISupplyFormFactory $supplyFormFactory, TemporarySupplyProducts $temporarySupplyProducts,
								IOverviewGridFactory $overviewGridFactory, IDemandGridFactory $demandGridFactory,
								IToDateFormFactory $toDateFormFactory)
	{
		$this->stocksService = $stocksService;
		$this->stocks = $stocksService->getAll();
		$this->supplyFormFactory = $supplyFormFactory;
		$this->overviewGridFactory = $overviewGridFactory;
		$this->demandGridFactory = $demandGridFactory;
		$this->setActiveComponent($activeComponent);
		$this->temporarySupplyProducts = $temporarySupplyProducts;
		$this->activeStock = $activeStockId ? $this->stocksService->get($activeStockId) : null;
		$this->toDateFormFactory = $toDateFormFactory;
	}

	public function createComponentDefault(): OverviewGrid
	{
		return $this->overviewGridFactory->create($this->activeStock->getId());
	}

	public function createComponentSupply(): SupplyForm
	{
		$form = $this->supplyFormFactory->create($this->activeStock->getId());

		$form['form']->onSuccess[] = function () {
			$this->presenter->redirect('default', $this->activeStock->getId());
		};

		return $form;
	}

	public function createComponentDemand(): DemandGrid
	{
		return $this->demandGridFactory->create($this->activeStock->getId());
	}

	public function createComponentToDate(): ToDateForm
	{
		return $this->toDateFormFactory->create($this->activeStock->getId());
	}

	public function setActiveComponent(string $name): void
	{
		if (in_array($name, static::getContentComponents(), true)) {
			$this->activeComponent = $name;
		} else {
			throw new InvalidArgumentException("$name component does not exists");
		}
	}

	public function render(): void
	{
		$this->template->components = static::getContentComponents();
		$this->template->activeComponent = $this->activeComponent;
		$this->template->activeStock = $this->activeStock;
		$this->template->stocks = $this->stocks;
		$this->template->render($this->getTemplateFile());
	}

	/**
	 * @return string[]
	 */
	public static function getContentComponents(): array
	{
		return ['default', 'supply', 'demand', 'toDate'];
	}

}
