<?php declare(strict_types=1);

namespace EshopStock\AdminModule\Presenters;

use EshopStock\Model\Repository\Stocks;
use Nette\Application\BadRequestException;

abstract class BasePresenter extends \Core\AdminModule\Presenters\BasePresenter
{
	/** @var Stocks @inject */
	public Stocks $stocksService;

	/**
	 * @param mixed $element
	 * @throws BadRequestException
	 */
	public function checkRequirements($element): void
	{
		parent::checkRequirements($element);
		if (!$this->getUser()->isAllowed($this->getFullModuleName(), 'access')) {
			$this->error();
		}
	}
}
