<?php declare(strict_types=1);

namespace EshopStock\AdminModule\Presenters;

use EshopStock\AdminModule\Components\IStocksTabsFactory;
use EshopStock\AdminModule\Components\StocksTabs;
use EshopStock\Model\Repository\TemporarySupplyProducts;
use Nette\Application\BadRequestException;

class DefaultPresenter extends BasePresenter
{
	public const STOCK_ICON = 'fas fa-warehouse';

	/** @var IStocksTabsFactory @inject */
	public IStocksTabsFactory $factory;

	/** @var TemporarySupplyProducts @inject */
	public TemporarySupplyProducts $temporarySupplyProductsService;

	protected function startup(): void
	{
		parent::startup();
		$this['title']->setTitle($this->translator->translate('eshopStock.title.stock'));
		$this->setHeader('eshopStock.title.stock', static::STOCK_ICON);
	}

	/**
	 * @param string|int|null $id
	 */
	public function actionDefault($id = null): void
	{
		$this['stocksTabs']->setActiveComponent('default');
	}

	/**
	 * @param string|int|null $id
	 * @throws BadRequestException
	 */
	public function actionSupply($id = null): void
	{
		if (!$this->isAjax()) {
			$this->temporarySupplyProductsService->clear();
		}
		if (!$this->user->isAllowed($this->getFullModuleName(), 'edit')) {
			$this->error();
		}
		$this['stocksTabs']->setActiveComponent('supply');
	}

	/**
	 * @param string|int|null $id
	 */
	public function actionDemand($id = null): void
	{
		$this['stocksTabs']->setActiveComponent('demand');
	}

	/**
	 * @param string|int|null $id
	 */
	public function actionToDate($id = null): void
	{
		$this['stocksTabs']->setActiveComponent('toDate');
	}

	public function createComponentStocksTabs(IStocksTabsFactory $factory): StocksTabs
	{
		$id = $this->getParameter('id');
		if ($id) {
			$id = (int) $id;
		} else {
			$defaultStock = $this->stocksService->getDefaultStock();
			$id = $defaultStock ? $defaultStock->getId() : null;
		}
		return $factory->create('default', $id);
	}

}