<?php declare(strict_types = 1);

namespace EshopStock\DI;

use Core\DI\CompilerExtension;
use Nette;

class EshopStockExtension extends CompilerExtension
{
	public function loadConfiguration(): void
	{
		parent::loadConfiguration();
		$this->setConfig($this->loadFromFile(__DIR__ . '/config.neon'));

		$this->compiler->loadDefinitionsFromConfig($this->loadFromFile(__DIR__ . '/services.neon'));
	}

	public function beforeCompile(): void
	{
		parent::beforeCompile();
		$this->setMapping(['EshopStock' => 'EshopStock\*Module\Presenters\*Presenter']);
	}

	public function afterCompile(Nette\PhpGenerator\ClassType $class): void
	{
		parent::afterCompile($class);
		$init    = $class->methods['initialize'];
		$builder = $this->getContainerBuilder();

		$init->addBody('EshopStock\Model\EshopStockConfig::setParams($this->parameters[\'eshopStock\']);');
	}

}
