<?php declare(strict_types=1);

namespace EshopStock\Model\Entities;

use EshopOrders\Model\Entities\Order;
use Core\Model\Entities\TId;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table("eshop_stock__products_to_order_orders")
 * @ORM\Entity
 * @ORM\EntityListeners({"EshopStock\Model\Listeners\ProductsToOrderOrdersListener"})
 */
class ProductsToOrderOrders
{
	use TId;

	/**
	 * @ORM\ManyToOne(targetEntity="EshopOrders\Model\Entities\Order", cascade={"persist"})
	 * @ORM\JoinColumn(name="order_id", referencedColumnName="id")
	 */
	public ?Order $order = null;

	/**
	 * @ORM\ManyToOne(targetEntity="ProductToOrder", inversedBy="orders")
	 * @ORM\JoinColumn(name="product_to_order_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	public ?ProductToOrder $productToOrder = null;

	public function __construct(Order $order, ProductToOrder $productToOrder)
	{
		$this->order = $order;
		$this->productToOrder = $productToOrder;
	}

}
