<?php declare(strict_types=1);

namespace EshopStock\Model\Entities;

use Doctrine\Common\Collections\ArrayCollection;
use Core\Model\Entities\TId;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table("eshop_stock__stock")
 * @ORM\Entity
 */
class Stock
{
	use TId;

	/**
	 * @ORM\Column(type="string")
	 */
	public string $name;

	/**
	 * @var Collection<Supply>
	 * @ORM\OneToMany(targetEntity="Supply", mappedBy="stock")
	 */
	protected Collection $items;

	public function __construct(string $name)
	{
		$this->name = $name;
		$this->items = new ArrayCollection;
	}

}
