<?php declare(strict_types = 1);

namespace EshopStock\Model\Entities;

use DateTime;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use EshopCatalog\Model\Entities\Supplier;
use Core\Model\Entities\TId;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table("eshop_stock__supply")
 * @ORM\Entity
 */
class Supply
{
	use TId;

	/**
	 * @ORM\ManyToOne(targetEntity="EshopCatalog\Model\Entities\Supplier")
	 * @ORM\JoinColumn(name="supplier_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	public ?Supplier $supplier = null;

	/**
	 * @ORM\Column(type="string", length=255)
	 */
	public string $invoiceNumber;

	/**
	 * @var DateTime
	 * @ORM\Column(type="datetime")
	 */
	public $dateSupply;

	/**
	 * @var Collection<SupplyProduct>
	 * @ORM\OneToMany(targetEntity="SupplyProduct", mappedBy="supply", cascade={"all"})
	 */
	protected Collection $supplyProducts;

	/**
	 * @ORM\ManyToOne(targetEntity="Stock")
	 * @ORM\JoinColumn(name="stock_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	protected ?Stock $stock = null;

	public function __construct(Stock $stock, Supplier $supplier, string $invoiceNumber, DateTime $dateSupply)
	{
		$this->stock          = $stock;
		$this->supplier       = $supplier;
		$this->invoiceNumber  = $invoiceNumber;
		$this->dateSupply     = $dateSupply;
		$this->supplyProducts = new ArrayCollection;
	}

	/**
	 * @return Collection<SupplyProduct>
	 */
	public function getSupplyProducts() { return $this->supplyProducts; }

	/**
	 * @param SupplyProduct $supplyProduct
	 */
	public function addSupplyProduct(SupplyProduct $supplyProduct): void
	{
		$this->supplyProducts->add($supplyProduct);
	}

	public function getPurchasePriceSum(): float
	{
		$sum = 0;

		foreach ($this->supplyProducts->toArray() as $supplyProduct) {
			$sum += $supplyProduct->purchasePrice;
		}

		return $sum;
	}

}
