<?php declare(strict_types=1);

namespace EshopStock\Model\Entities;

use EshopCatalog\Model\Entities\Product;
use EshopOrders\Model\Entities\Order;
use Core\Model\Entities\TId;
use Doctrine\ORM\Mapping as ORM;
use Nette\Utils\DateTime;

/**
 * @ORM\Table("eshop_stock__supply_product")
 * @ORM\Entity
 */
class SupplyProduct
{
	use TId;

	/**
	 * @ORM\ManyToOne(targetEntity="EshopCatalog\Model\Entities\Product")
	 * @ORM\JoinColumn(name="product_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	public ?Product $product = null;

	/**
	 * @ORM\ManyToOne(targetEntity="Supply")
	 * @ORM\JoinColumn(name="supply_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	public ?Supply $supply = null;

	/**
	 * @var float|string
	 * @ORM\Column(name="purchasePrice", type="decimal", precision=10, scale=2)
	 */
	public $purchasePrice;

	/**
	 * @ORM\ManyToOne(targetEntity="EshopOrders\Model\Entities\Order", cascade={"persist"})
	 * @ORM\JoinColumn(name="order_id", referencedColumnName="id", nullable=true, onDelete="SET NULL")
	 */
	public ?Order $order = null;

	/**
	 * @var DateTime|null
	 * @ORM\Column(type="datetime", nullable=true)
	 */
	public $writtenOffDate;

	public function __construct(Product $product, Supply $supply, string $purchasePrice)
	{
		$this->product = $product;
		$this->supply = $supply;
		$this->purchasePrice = $purchasePrice;
	}

	public function isWrittenOff(): bool
	{
		return $this->writtenOffDate !== null;
	}

	public function hasOrder(): bool
	{
		return $this->order !== null;
	}

	public function setWrittenOff(): void
	{
		$this->writtenOffDate = new DateTime;
	}

}
