<?php declare(strict_types=1);

namespace EshopStock\Model\Listeners;

use Doctrine\ORM\Event\LifecycleEventArgs;
use EshopStock\Model\Entities\ProductToOrder;
use Doctrine\ORM\Mapping as ORM;

class ProductToOrderOrderListener
{
	/**
	 * @ORM\PostUpdate
	 */
	public function postUpdateHandler(ProductToOrder $entity, LifecycleEventArgs $events): void
	{
		$em = $events->getEntityManager();
		if ($entity->quantity >= 0) {
			$em->remove($entity);
		}
	}
}