<?php declare(strict_types=1);

namespace EshopStock\Model\Listeners;

use Doctrine\ORM\Event\LifecycleEventArgs;
use EshopStock\Model\Entities\ProductsToOrderOrders;
use Doctrine\ORM\Mapping as ORM;

class ProductsToOrderOrdersListener
{
	/**
	 * @ORM\PostRemove
	 */
	public function postRemoveHandler(ProductsToOrderOrders $entity, LifecycleEventArgs $events): void
	{
		$em = $events->getEntityManager();
		if ($entity->productToOrder->orders->count() === 0) {
			$em->remove($entity->productToOrder);
		}
	}
}