<?php declare(strict_types=1);

namespace EshopStock\Model\Subscribers;

use EshopCatalog\AdminModule\Model\Suppliers;
use EshopOrders\Model\Entities\OrderItem;
use EshopOrders\Model\Utils\Helpers;
use EshopStock\Model\EshopStockConfig;
use EshopStock\Model\Repository\Stocks;
use EshopStock\Model\Repository\Supplies;
use Nette\Utils\DateTime;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use EshopOrders\FrontModule\Model\Event\OrderEvent;
use EshopStock\Model\Repository\SupplyProducts;

class OrderFormSubscriber implements EventSubscriberInterface
{
	protected SupplyProducts $supplyProducts;
	protected Supplies $supplies;
	protected Stocks $stocks;
	protected Suppliers $suppliers;

	public function __construct(SupplyProducts $supplyProducts, Supplies $supplies, Stocks $stocks, Suppliers $suppliers)
	{
		$this->supplyProducts = $supplyProducts;
		$this->supplies = $supplies;
		$this->stocks = $stocks;
		$this->suppliers = $suppliers;
	}

	public static function getSubscribedEvents(): array
	{
		return [
			'eshopOrders.orderBeforeSave' => ['orderBeforeSave', 100],
			'eshopCheckout.orderBeforeSave' => ['orderBeforeSave', 100],
			'eshopOrders.admin.correctiveTaxDocumentCreated' => ['correctiveTaxDocumentCreated', 100]
		];
	}

	public function orderBeforeSave(OrderEvent $event): void
	{
		if (Helpers::isCorrectiveByOrderItems($event->order->getOrderItems()->toArray())) {
			return;
		}
		$this->supplyProducts->assignOrder($event->order);
	}

	public function correctiveTaxDocumentCreated(OrderEvent $event): void
	{
		$invoiceNumber = $event->order->getInvoice()->ident;
		$stock = $this->stocks->getDefaultStock();
		$supplier = $this->suppliers->get((int) EshopStockConfig::load('defaultSupplierIdForCorrective'));
		$dateSupply = new DateTime;
		$products = [];
		/** @var OrderItem $item */
		foreach ($event->order->getOrderItems()->toArray() as $item) {
			$products[$item->getProduct()->getId()] = ['quantity' => $item->getQuantity(), 'purchasePrice' => $item->getProduct()->purchasePrice];
		}
		$this->supplies->createSupply($stock, $supplier, $invoiceNumber, $dateSupply, $products);
	}

}
